/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.fluent.collections;

import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.fluent.collections.ImmutableListImpl;
import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.fluent.collections.ImmutableSetImpl;
import com.floragunn.fluent.collections.UnmodifiableCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

class ImmutableMapImpl {
    static final Map<?, ?> EMPTY_MAP = new AbstractImmutableMap<Object, Object>(){

        @Override
        public ImmutableSet<Map.Entry<Object, Object>> entrySet() {
            return ImmutableSet.empty();
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean containsValue(Object value) {
            return false;
        }

        @Override
        public boolean containsKey(Object key) {
            return false;
        }

        @Override
        public Object get(Object key) {
            return null;
        }

        @Override
        public ImmutableSet<Object> keySet() {
            return ImmutableSet.empty();
        }

        @Override
        public UnmodifiableCollection<Object> values() {
            return ImmutableSet.empty();
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map)) {
                return false;
            }
            Map otherMap = (Map)o;
            return otherMap.size() == 0;
        }

        @Override
        public String toString() {
            return "{}";
        }

        @Override
        public ImmutableMap<Object, Object> with(Object key, Object value) {
            return ImmutableMap.of(key, value);
        }

        @Override
        public ImmutableMap<Object, Object> with(ImmutableMap<Object, Object> other) {
            return other;
        }

        @Override
        public ImmutableMap<Object, Object> matching(Predicate<Object> predicate) {
            return this;
        }

        @Override
        public <VT> ImmutableMap<Object, VT> mapValues(Function<Object, VT> valueMappingFunction) {
            return ImmutableMapImpl.empty();
        }

        @Override
        public boolean forAllKeysApplies(Predicate<Object> predicate) {
            return true;
        }

        @Override
        public boolean forAnyKeyApplies(Predicate<Object> predicate) {
            return false;
        }

        @Override
        public <KT, VT> ImmutableMap<KT, VT> assertElementType(Class<KT> keyType, Class<VT> valueType) {
            return ImmutableMapImpl.empty();
        }
    };

    ImmutableMapImpl() {
    }

    static <K, V> ImmutableMap<K, V> of(Map<K, V> map) {
        int size = map.size();
        if (map instanceof ImmutableMap) {
            return (ImmutableMap)map;
        }
        if (size == 0) {
            return ImmutableMapImpl.empty();
        }
        if (size == 1) {
            Map.Entry<K, V> entry = map.entrySet().iterator().next();
            return new SingleElementMap<K, V>(entry.getKey(), entry.getValue());
        }
        if (size == 2) {
            Iterator<Map.Entry<K, V>> iter = map.entrySet().iterator();
            Map.Entry<K, V> entry1 = iter.next();
            Map.Entry<K, V> entry2 = iter.next();
            return new TwoElementMap<K, V>(entry1.getKey(), entry1.getValue(), entry2.getKey(), entry2.getValue());
        }
        if (size < 8) {
            return new ArrayBackedMap<K, V>(map);
        }
        if (size < 400) {
            return new ImmutableMap.Builder<K, V>(map).build();
        }
        return new MapBackedMap<K, V>(new LinkedHashMap<K, V>(map));
    }

    static <K, V> ImmutableMap<K, V> of(K k1, V v1) {
        return new SingleElementMap<K, V>(k1, v1);
    }

    static <K, V> ImmutableMap<K, V> of(K k1, V v1, K k2, V v2) {
        if (k1.equals(k2)) {
            return new SingleElementMap<K, V>(k1, v1);
        }
        return new TwoElementMap<K, V>(k1, v1, k2, v2);
    }

    static <K, V> ImmutableMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3) {
        if (k1.equals(k2)) {
            if (k2.equals(k3)) {
                return new SingleElementMap<K, V>(k1, v1);
            }
            return new TwoElementMap<K, V>(k1, v1, k3, v3);
        }
        if (k2.equals(k3)) {
            return new TwoElementMap<K, V>(k1, v1, k2, v2);
        }
        if (k1.equals(k3)) {
            return new TwoElementMap<K, V>(k1, v1, k2, v2);
        }
        return new ArrayBackedMap<K, V>(k1, v1, k2, v2, k3, v3);
    }

    static <K, V> ImmutableMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4) {
        if (k4.equals(k3)) {
            return ImmutableMapImpl.of(k1, v1, k2, v2, k4, v4);
        }
        if (k4.equals(k2)) {
            return ImmutableMapImpl.of(k1, v1, k3, v3, k4, v4);
        }
        if (k4.equals(k1)) {
            return ImmutableMapImpl.of(k2, v2, k3, v3, k4, v4);
        }
        if (k3.equals(k2)) {
            return ImmutableMapImpl.of(k1, v1, k3, v3, k4, v4);
        }
        if (k3.equals(k1)) {
            return ImmutableMapImpl.of(k2, v2, k3, v3, k4, v4);
        }
        if (k2.equals(k1)) {
            return ImmutableMapImpl.of(k2, v2, k3, v3, k4, v4);
        }
        return new ArrayBackedMap<K, V>(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    static <K, V> ImmutableMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5) {
        if (k5.equals(k4)) {
            return ImmutableMapImpl.of(k1, v1, k2, v2, k3, v3, k5, v5);
        }
        if (k5.equals(k3)) {
            return ImmutableMapImpl.of(k1, v1, k2, v2, k4, v4, k5, v5);
        }
        if (k5.equals(k2)) {
            return ImmutableMapImpl.of(k1, v1, k3, v3, k4, v4, k5, v5);
        }
        if (k5.equals(k1)) {
            return ImmutableMapImpl.of(k2, v2, k3, v3, k4, v4, k5, v5);
        }
        if (k4.equals(k3)) {
            return ImmutableMapImpl.of(k1, v1, k2, v2, k4, v4, k5, v5);
        }
        if (k4.equals(k2)) {
            return ImmutableMapImpl.of(k1, v1, k3, v3, k4, v4, k5, v5);
        }
        if (k4.equals(k1)) {
            return ImmutableMapImpl.of(k2, v2, k3, v3, k4, v4, k5, v5);
        }
        if (k3.equals(k2)) {
            return ImmutableMapImpl.of(k1, v1, k3, v3, k4, v4, k5, v5);
        }
        if (k3.equals(k1)) {
            return ImmutableMapImpl.of(k2, v2, k3, v3, k4, v4, k5, v5);
        }
        if (k2.equals(k1)) {
            return ImmutableMapImpl.of(k2, v2, k3, v3, k4, v4, k5, v5);
        }
        return new ArrayBackedMap<K, V>(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    static <K, V> ImmutableMap<K, V> ofNonNull(K k1, V v1) {
        if (k1 != null && v1 != null) {
            return ImmutableMapImpl.of(k1, v1);
        }
        return ImmutableMapImpl.empty();
    }

    static <K, V> ImmutableMap<K, V> ofNonNull(K k1, V v1, K k2, V v2) {
        if (v1 != null && k1 != null && v2 != null && k2 != null) {
            return ImmutableMapImpl.of(k1, v1, k2, v2);
        }
        if (k1 != null && v1 != null) {
            return ImmutableMapImpl.of(k1, v1);
        }
        if (k2 != null && v2 != null) {
            return ImmutableMapImpl.of(k2, v2);
        }
        return ImmutableMapImpl.empty();
    }

    static <K, V> ImmutableMap<K, V> ofNonNull(K k1, V v1, K k2, V v2, K k3, V v3) {
        if (k3 == null || v3 == null) {
            return ImmutableMapImpl.ofNonNull(k1, v1, k2, v2);
        }
        if (k1 != null && v1 != null) {
            if (k2 != null && v2 != null) {
                return ImmutableMapImpl.of(k1, v1, k2, v2, k3, v3);
            }
            return ImmutableMapImpl.of(k1, v1, k3, v3);
        }
        if (k2 != null && v2 != null) {
            return ImmutableMapImpl.of(k2, v2, k3, v3);
        }
        return ImmutableMapImpl.of(k3, v3);
    }

    static <K, V> ImmutableMap<K, V> ofNonNull(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4) {
        if (k4 == null || v4 == null) {
            return ImmutableMapImpl.ofNonNull(k1, v1, k2, v2, k3, v3);
        }
        if (k1 != null && v1 != null) {
            if (k2 != null && v2 != null) {
                if (k3 != null && v3 != null) {
                    return ImmutableMapImpl.of(k1, v1, k2, v2, k3, v3, k4, v4);
                }
                return ImmutableMapImpl.of(k1, v1, k2, v2, k4, v4);
            }
            if (k3 != null && v3 != null) {
                return ImmutableMapImpl.of(k1, v1, k3, v3, k4, v4);
            }
            return ImmutableMapImpl.of(k1, v1, k4, v4);
        }
        if (k2 != null && v2 != null) {
            if (k3 != null && v3 != null) {
                return ImmutableMapImpl.of(k2, v2, k3, v3, k4, v4);
            }
            return ImmutableMapImpl.of(k2, v2, k4, v4);
        }
        if (k3 != null && v3 != null) {
            return ImmutableMapImpl.of(k3, v3, k4, v4);
        }
        return ImmutableMapImpl.of(k4, v4);
    }

    static <K, V> ImmutableMap<K, V> ofNonNull(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5) {
        if (k5 == null || v5 == null) {
            return ImmutableMapImpl.ofNonNull(k1, v1, k2, v2, k3, v3, k4, v4);
        }
        if (k1 != null && v1 != null) {
            if (k2 != null && v2 != null) {
                if (k3 != null && v3 != null) {
                    if (k4 != null && v4 != null) {
                        return ImmutableMapImpl.of(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
                    }
                    return ImmutableMapImpl.of(k1, v1, k2, v2, k3, v3, k5, v5);
                }
                if (k4 != null && v4 != null) {
                    return ImmutableMapImpl.of(k1, v1, k2, v2, k4, v4, k5, v5);
                }
                return ImmutableMapImpl.of(k1, v1, k2, v2, k5, v5);
            }
            if (k3 != null && v3 != null) {
                if (k4 != null && v4 != null) {
                    return ImmutableMapImpl.of(k1, v1, k3, v3, k4, v4, k5, v5);
                }
                return ImmutableMapImpl.of(k1, v1, k3, v3, k5, v5);
            }
            if (k4 != null && v4 != null) {
                return ImmutableMapImpl.of(k1, v1, k4, v4, k5, v5);
            }
            return ImmutableMapImpl.of(k1, v1, k5, v5);
        }
        if (k2 != null && v2 != null) {
            if (k3 != null && v3 != null) {
                if (k4 != null && v4 != null) {
                    return ImmutableMapImpl.of(k2, v2, k3, v3, k4, v4, k5, v5);
                }
                return ImmutableMapImpl.of(k2, v2, k3, v3, k5, v5);
            }
            if (k4 != null && v4 != null) {
                return ImmutableMapImpl.of(k2, v2, k4, v4, k5, v5);
            }
            return ImmutableMapImpl.of(k2, v2, k5, v5);
        }
        if (k3 != null && v3 != null) {
            if (k4 != null && v4 != null) {
                return ImmutableMapImpl.of(k3, v3, k4, v4, k5, v5);
            }
            return ImmutableMapImpl.of(k3, v3, k5, v5);
        }
        if (k4 != null && v4 != null) {
            return ImmutableMapImpl.of(k4, v4, k5, v5);
        }
        return ImmutableMapImpl.of(k5, v5);
    }

    static <K, V> ImmutableMap<K, V> of(Map<K, V> map, K k1, V v1) {
        if (map == null || map.isEmpty()) {
            return ImmutableMapImpl.of(k1, v1);
        }
        if (map.size() == 1) {
            Map.Entry<K, V> entry = map.entrySet().iterator().next();
            return ImmutableMapImpl.of(entry.getKey(), entry.getValue(), k1, v1);
        }
        ImmutableMap.Builder<K, V> builder = new ImmutableMap.Builder<K, V>(map).with(k1, v1);
        return builder.build();
    }

    static <K, V> ImmutableMap<K, V> of(Map<K, V> map, K k1, V v1, K k2, V v2) {
        if (map == null || map.isEmpty()) {
            return ImmutableMapImpl.of(k1, v1, k2, v2);
        }
        ImmutableMap.Builder<K, V> builder = new ImmutableMap.Builder<K, V>(map).with(k1, v1).with(k2, v2);
        return builder.build();
    }

    static <K, V> ImmutableMap<K, V> without(Map<K, V> map, K key) {
        if (map.containsKey(key)) {
            if (map.size() == 1) {
                return ImmutableMapImpl.empty();
            }
            return new WithoutMap<K, V>(map, key);
        }
        return ImmutableMap.of(map);
    }

    static <C, K, V> ImmutableMap<K, V> map(Collection<C> collection, Function<C, Map.Entry<K, V>> mappingFunction) {
        ImmutableMap.Builder<K, V> builder = new ImmutableMap.Builder<K, V>(collection.size());
        for (C c : collection) {
            Map.Entry<K, V> entry = mappingFunction.apply(c);
            if (entry == null) continue;
            builder.put(entry.getKey(), entry.getValue());
        }
        return builder.build();
    }

    static <KS, VS, KT, VT> ImmutableMap<KT, VT> map(Map<KS, VS> source, Function<KS, KT> keyMappingFunction, Function<VS, VT> valueMappingFunction) {
        ImmutableMap.Builder<KT, VT> builder = new ImmutableMap.Builder<KT, VT>(source.size());
        for (Map.Entry<KS, VS> entry : source.entrySet()) {
            KT newKey = keyMappingFunction.apply(entry.getKey());
            VT newValue = valueMappingFunction.apply(entry.getValue());
            if (newKey == null || newValue == null) continue;
            builder.put(newKey, newValue);
        }
        return builder.build();
    }

    static <K, V> Map.Entry<K, V> entry(K k1, V v1) {
        return new AbstractMap.SimpleImmutableEntry<K, V>(k1, v1);
    }

    static <K, V> ImmutableMap<K, V> empty() {
        return (ImmutableMap)EMPTY_MAP;
    }

    static abstract class AbstractImmutableMap<K, V>
    extends AbstractMap<K, V>
    implements ImmutableMap<K, V> {
        AbstractImmutableMap() {
        }

        @Override
        @Deprecated
        public V put(K key, V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public V remove(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public void putAll(Map<? extends K, ? extends V> m) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public UnmodifiableCollection<V> values() {
            return UnmodifiableCollection.of(super.values());
        }

        @Override
        public ImmutableMap<K, V> without(K key) {
            if (this.containsKey(key)) {
                if (this.size() == 1) {
                    return ImmutableMapImpl.empty();
                }
                return new WithoutMap(this, key);
            }
            return this;
        }

        @Override
        public ImmutableMap<K, V> withComputed(K key, Function<V, V> f) {
            V newValue;
            Object oldValue = this.get(key);
            if (Objects.equals(oldValue, newValue = f.apply(oldValue))) {
                return this;
            }
            return this.with(key, newValue);
        }

        @Override
        public ImmutableMap<K, V> with(ImmutableMap<K, V> other) {
            if (this.size() == 0) {
                return other;
            }
            if (other.size() == 0) {
                return this;
            }
            LinkedHashMap<K, V> map = new LinkedHashMap<K, V>(this);
            map.putAll(other);
            return new MapBackedMap(map);
        }

        @Override
        public ImmutableMap<K, V> intersection(ImmutableSet<K> keys) {
            int otherSize = keys.size();
            if (otherSize == 0) {
                return ImmutableMapImpl.empty();
            }
            if (otherSize == 1) {
                K otherKey = keys.only();
                if (this.containsKey(otherKey)) {
                    return new SingleElementMap(otherKey, this.get(otherKey));
                }
                return ImmutableMapImpl.empty();
            }
            ImmutableMap.Builder builder = new ImmutableMap.Builder();
            for (Object key : keys) {
                if (!this.containsKey(key)) continue;
                builder.with(key, this.get(key));
            }
            return builder.build();
        }

        @Override
        public boolean containsAny(ImmutableSet<K> keys) {
            int otherSize = keys.size();
            if (otherSize == 0) {
                return false;
            }
            if (otherSize == 1) {
                return this.containsKey(keys.only());
            }
            for (Object key : keys) {
                if (!this.containsKey(key)) continue;
                return true;
            }
            return false;
        }

        @Override
        public ImmutableSet<K> keySet() {
            return ImmutableSet.of(super.keySet());
        }

        @Override
        public ImmutableList<V> values(BiPredicate<K, V> predicate) {
            ImmutableList.Builder result = new ImmutableList.Builder(this.size());
            this.forEach((k, v) -> {
                if (predicate.test(k, v)) {
                    result.with(v);
                }
            });
            return result.build();
        }

        @Override
        public ImmutableList<V> valuesForKeys(ImmutableSet<K> keys) {
            if (keys.size() < this.size()) {
                ImmutableList.Builder result = new ImmutableList.Builder(keys.size());
                keys.forEach((? super T k) -> {
                    Object v = this.get(k);
                    if (v != null) {
                        result.with(v);
                    }
                });
                return result.build();
            }
            return this.values((k, v) -> keys.contains(k));
        }

        @Override
        public <KT, VT> ImmutableMap<KT, VT> map(Function<K, KT> keyMappingFunction, Function<V, VT> valueMappingFunction) {
            return ImmutableMapImpl.map(this, keyMappingFunction, valueMappingFunction);
        }

        @Override
        public <VT> ImmutableMap<K, VT> mapValues(Function<V, VT> valueMappingFunction) {
            ImmutableMap.Builder builder = new ImmutableMap.Builder(this.size());
            for (Map.Entry entry : this.entrySet()) {
                VT newValue = valueMappingFunction.apply(entry.getValue());
                if (newValue == null) continue;
                builder.put(entry.getKey(), newValue);
            }
            return builder.build();
        }

        @Override
        public <KT> ImmutableMap<KT, V> ensureKeyType(Class<KT> keyType, Function<Object, KT> conversionFunction) {
            if (this.forAllKeysApplies(k -> keyType.isAssignableFrom(k.getClass()))) {
                AbstractImmutableMap result = this;
                return result;
            }
            return this.map(k -> conversionFunction.apply(k), v -> v);
        }

        static <K, V> Map.Entry<K, V> entry(final K key, final V value) {
            return new Map.Entry<K, V>(){

                @Override
                public K getKey() {
                    return key;
                }

                @Override
                public V getValue() {
                    return value;
                }

                @Override
                public V setValue(V value2) {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public <KT, VT> ImmutableMap<KT, VT> assertElementType(Class<KT> keyType, Class<VT> valueType) {
            AbstractImmutableMap result = this;
            if (keyType.equals(Object.class) && valueType.equals(Object.class)) {
                return result;
            }
            for (Map.Entry entry : this.entrySet()) {
                Object key = entry.getKey();
                Object value = entry.getValue();
                if (!keyType.isAssignableFrom(key.getClass())) {
                    throw new ClassCastException("Key " + key + " is not compatible with expected type " + keyType);
                }
                if (value == null || valueType.isAssignableFrom(value.getClass())) continue;
                throw new ClassCastException("Value " + value + " is not compatible with expected type " + valueType);
            }
            return result;
        }
    }

    static class WithMap<K, V>
    extends AbstractImmutableMap<K, V> {
        private final ImmutableMap<K, V> base;
        private final K additional;
        private final Map.Entry<K, V> additionalEntry;
        private final int size;

        WithMap(ImmutableMap<K, V> base, K additional, V additionalValue) {
            this.base = base;
            this.additional = additional;
            this.additionalEntry = new AbstractMap.SimpleEntry<K, V>(additional, additionalValue);
            this.size = base.size() + 1;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public V get(Object key) {
            if (this.additional.equals(key)) {
                return this.additionalEntry.getValue();
            }
            return this.base.get(key);
        }

        @Override
        public boolean containsKey(Object o) {
            return Objects.equals(o, this.additional) || this.base.containsKey(o);
        }

        @Override
        public int hashCode() {
            return this.base.hashCode() + this.additional.hashCode();
        }

        @Override
        public ImmutableMap<K, V> with(K key, V value) {
            int size = this.size();
            if (size == 0) {
                return new SingleElementMap<K, V>(key, value);
            }
            if (Objects.equals(this.get(key), value)) {
                return this;
            }
            return new ImmutableMap.Builder<K, V>(this).with(key, value).build();
        }

        @Override
        public ImmutableSet<Map.Entry<K, V>> entrySet() {
            return this.base.entrySet().with(this.additionalEntry);
        }

        @Override
        public void forEach(BiConsumer<? super K, ? super V> action) {
            this.base.forEach(action);
            action.accept(this.additional, this.additionalEntry.getValue());
        }

        @Override
        public ImmutableMap<K, V> matching(Predicate<K> predicate) {
            if (predicate.test(this.additional)) {
                ImmutableMap<K, V> matchingBase = this.base.matching(predicate);
                if (matchingBase == this.base) {
                    return this;
                }
                return new WithMap<K, V>(matchingBase, this.additional, this.additionalEntry.getValue());
            }
            return this.base.matching(predicate);
        }

        @Override
        public boolean forAllKeysApplies(Predicate<K> predicate) {
            return predicate.test(this.additional) && this.base.forAllKeysApplies(predicate);
        }

        @Override
        public boolean forAnyKeyApplies(Predicate<K> predicate) {
            return predicate.test(this.additional) || this.base.forAnyKeyApplies(predicate);
        }

        @Override
        public <KT, VT> ImmutableMap<KT, VT> assertElementType(Class<KT> keyType, Class<VT> valueType) {
            this.base.assertElementType(keyType, valueType);
            if (!keyType.isAssignableFrom(this.additional.getClass())) {
                throw new ClassCastException("Key " + this.additional + " is not compatible with expected type " + keyType);
            }
            if (this.additionalEntry.getValue() != null && !valueType.isAssignableFrom(this.additionalEntry.getValue().getClass())) {
                throw new ClassCastException("Value " + this.additionalEntry.getValue() + " is not compatible with expected type " + valueType);
            }
            WithMap result = this;
            return result;
        }
    }

    static class WithoutMap<K, V>
    extends AbstractImmutableMap<K, V> {
        private final Map<K, V> delegate;
        private final K withoutKey;

        WithoutMap(Map<K, V> delegate, K withoutKey) {
            this.delegate = delegate;
            this.withoutKey = withoutKey;
        }

        @Override
        public int size() {
            return this.delegate.size() - 1;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean containsKey(Object key) {
            if (this.withoutKey.equals(key)) {
                return false;
            }
            return this.delegate.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            for (Map.Entry<K, V> entry : this.delegate.entrySet()) {
                if (this.withoutKey.equals(entry.getKey()) || !Objects.equals(value, entry.getValue())) continue;
                return true;
            }
            return false;
        }

        @Override
        public V get(Object key) {
            if (this.withoutKey.equals(key)) {
                return null;
            }
            return this.delegate.get(key);
        }

        @Override
        public ImmutableSet<K> keySet() {
            return ImmutableSet.of(this.delegate.keySet()).without(this.withoutKey);
        }

        @Override
        public UnmodifiableCollection<V> values() {
            return UnmodifiableCollection.of(this.entrySet().stream().map(e -> e.getValue()).collect(Collectors.toSet()));
        }

        @Override
        public ImmutableSet<Map.Entry<K, V>> entrySet() {
            final Set<Map.Entry<K, V>> delegateSet = this.delegate.entrySet();
            return new ImmutableSetImpl.SetBackedSet<Map.Entry<K, V>>(new AbstractSet<Map.Entry<K, V>>(){

                @Override
                public int size() {
                    return this.size();
                }

                @Override
                public boolean isEmpty() {
                    return this.isEmpty();
                }

                @Override
                public boolean contains(Object o) {
                    return this.containsKey(o);
                }

                @Override
                public Iterator<Map.Entry<K, V>> iterator() {
                    final Iterator delegateIter = delegateSet.iterator();
                    return new Iterator<Map.Entry<K, V>>(){
                        private Map.Entry<K, V> next;
                        private boolean initialized;

                        @Override
                        public boolean hasNext() {
                            this.init();
                            return this.next != null;
                        }

                        @Override
                        public Map.Entry<K, V> next() {
                            this.init();
                            this.initialized = false;
                            return this.next;
                        }

                        private void init() {
                            if (!this.initialized) {
                                this.next = null;
                                while (delegateIter.hasNext()) {
                                    this.next = (Map.Entry)delegateIter.next();
                                    if (!withoutKey.equals(this.next.getKey())) break;
                                    this.next = null;
                                }
                                this.initialized = true;
                            }
                        }
                    };
                }

                @Override
                public boolean add(Map.Entry<K, V> e) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean remove(Object o) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean addAll(Collection<? extends Map.Entry<K, V>> c) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean retainAll(Collection<?> c) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean removeAll(Collection<?> c) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void clear() {
                    throw new UnsupportedOperationException();
                }
            });
        }

        @Override
        public ImmutableMap<K, V> with(K key, V value) {
            if (Objects.equals(this.delegate.get(key), value)) {
                return this;
            }
            ImmutableMap.Builder builder = new ImmutableMap.Builder<K, V>(this).with(key, value);
            return builder.build();
        }

        @Override
        public ImmutableMap<K, V> matching(Predicate<K> predicate) {
            if (this.delegate instanceof ImmutableMap) {
                return ((ImmutableMap)this.delegate).matching(k -> predicate.test(k) && !k.equals(this.withoutKey));
            }
            ImmutableMap.Builder builder = new ImmutableMap.Builder(this.delegate.size());
            this.delegate.forEach((k, v) -> {
                if (!k.equals(this.withoutKey) && predicate.test(k)) {
                    builder.with(k, v);
                }
            });
            return builder.build();
        }

        @Override
        public boolean forAllKeysApplies(Predicate<K> predicate) {
            return this.delegate.keySet().stream().filter(k -> !k.equals(this.withoutKey)).allMatch(predicate);
        }

        @Override
        public boolean forAnyKeyApplies(Predicate<K> predicate) {
            return this.delegate.keySet().stream().filter(k -> !k.equals(this.withoutKey)).anyMatch(predicate);
        }
    }

    static class MapBackedMap<K, V>
    extends AbstractImmutableMap<K, V> {
        private final Map<K, V> delegate;

        MapBackedMap(Map<K, V> delegate) {
            this.delegate = delegate;
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        @Override
        public boolean containsValue(Object value) {
            return this.delegate.containsValue(value);
        }

        @Override
        public boolean containsKey(Object key) {
            return this.delegate.containsKey(key);
        }

        @Override
        public V get(Object key) {
            return this.delegate.get(key);
        }

        @Override
        public ImmutableSet<K> keySet() {
            return ImmutableSet.of(this.delegate.keySet());
        }

        @Override
        public UnmodifiableCollection<V> values() {
            return UnmodifiableCollection.of(this.delegate.values());
        }

        @Override
        public ImmutableSet<Map.Entry<K, V>> entrySet() {
            return new ImmutableSetImpl.SetBackedSet<Map.Entry<K, V>>(this.delegate.entrySet());
        }

        @Override
        public boolean equals(Object o) {
            return this.delegate.equals(o);
        }

        @Override
        public int hashCode() {
            return this.delegate.hashCode();
        }

        @Override
        public String toString() {
            return this.delegate.toString();
        }

        @Override
        public ImmutableMap<K, V> with(K key, V value) {
            if (Objects.equals(this.delegate.get(key), value)) {
                return this;
            }
            LinkedHashMap<K, V> map = new LinkedHashMap<K, V>(this);
            map.put(key, value);
            return new MapBackedMap(map);
        }

        @Override
        public void forEach(BiConsumer<? super K, ? super V> action) {
            this.delegate.forEach(action);
        }

        @Override
        public ImmutableMap<K, V> matching(Predicate<K> predicate) {
            HashMap result = new HashMap(this.delegate.size());
            this.delegate.forEach((k, v) -> {
                if (predicate.test(k)) {
                    result.put(k, v);
                }
            });
            return new MapBackedMap(result);
        }

        @Override
        public boolean forAllKeysApplies(Predicate<K> predicate) {
            return this.delegate.keySet().stream().allMatch(predicate);
        }

        @Override
        public boolean forAnyKeyApplies(Predicate<K> predicate) {
            return this.delegate.keySet().stream().anyMatch(predicate);
        }

        static class Builder<K, V>
        extends InternalBuilder<K, V> {
            private HashMap<K, V> delegate;

            Builder(int expectedCapacity) {
                this.delegate = new HashMap(expectedCapacity);
            }

            Builder(Map<K, V> map) {
                this.delegate = new HashMap<K, V>(map);
            }

            @Override
            public Builder<K, V> with(K key, V value) {
                this.delegate.put(key, value);
                return this;
            }

            @Override
            ImmutableMap<K, V> build() {
                return new MapBackedMap<K, V>(this.delegate);
            }

            @Override
            InternalBuilder<K, V> with(Map<K, V> map) {
                this.delegate.putAll(map);
                return this;
            }

            @Override
            int size() {
                return this.delegate.size();
            }

            @Override
            boolean remove(K e) {
                return this.delegate.remove(e) != null;
            }

            @Override
            boolean contains(K e) {
                return this.delegate.containsKey(e);
            }

            @Override
            V get(K k) {
                return this.delegate.get(k);
            }

            @Override
            Set<K> keySet() {
                return this.delegate.keySet();
            }

            @Override
            <V2> ImmutableMap<K, V2> build(Function<V, V2> valueMappingFunction) {
                HashMap<K, V2> result = new HashMap<K, V2>(this.delegate.size());
                for (Map.Entry<K, V> entry : this.delegate.entrySet()) {
                    result.put(entry.getKey(), valueMappingFunction.apply(entry.getValue()));
                }
                return new MapBackedMap(result);
            }
        }
    }

    static class ArrayBackedMap<K, V>
    extends AbstractImmutableMap<K, V> {
        private final K[] keys;
        private final V[] values;
        private ImmutableSet<K> keySet;
        private ImmutableSet<V> valueSet;
        private ImmutableSet<Map.Entry<K, V>> entrySet;

        ArrayBackedMap(K k1, V v1, K k2, V v2, K k3, V v3) {
            this.keys = new Object[]{k1, k2, k3};
            this.values = new Object[]{v1, v2, v3};
        }

        ArrayBackedMap(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4) {
            this.keys = new Object[]{k1, k2, k3, k4};
            this.values = new Object[]{v1, v2, v3, v4};
        }

        ArrayBackedMap(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5) {
            this.keys = new Object[]{k1, k2, k3, k4, k5};
            this.values = new Object[]{v1, v2, v3, v4, v5};
        }

        ArrayBackedMap(Map<K, V> map) {
            this.keys = new Object[map.size()];
            this.values = new Object[map.size()];
            int i = 0;
            for (Map.Entry<K, V> entry : map.entrySet()) {
                this.keys[i] = entry.getKey();
                this.values[i] = entry.getValue();
                ++i;
            }
        }

        ArrayBackedMap(K[] keys, V[] values) {
            this.keys = keys;
            this.values = values;
        }

        @Override
        public int size() {
            return this.keys.length;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean containsValue(Object value) {
            for (int i = 0; i < this.values.length; ++i) {
                if (!Objects.equals(this.values[i], value)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean containsKey(Object key) {
            for (int i = 0; i < this.keys.length; ++i) {
                if (!Objects.equals(this.keys[i], key)) continue;
                return true;
            }
            return false;
        }

        @Override
        public V get(Object key) {
            for (int i = 0; i < this.keys.length; ++i) {
                if (!Objects.equals(this.keys[i], key)) continue;
                return this.values[i];
            }
            return null;
        }

        @Override
        public void forEach(BiConsumer<? super K, ? super V> action) {
            for (int i = 0; i < this.keys.length; ++i) {
                action.accept(this.keys[i], this.values[i]);
            }
        }

        @Override
        public ImmutableSet<K> keySet() {
            if (this.keySet == null) {
                this.keySet = new ImmutableSetImpl.ArrayBackedSet<K>(this.keys);
            }
            return this.keySet;
        }

        @Override
        public UnmodifiableCollection<V> values() {
            if (this.valueSet == null) {
                this.valueSet = ImmutableSet.of(new HashSet<V>(Arrays.asList(this.values)));
            }
            return this.valueSet;
        }

        @Override
        public ImmutableSet<Map.Entry<K, V>> entrySet() {
            if (this.entrySet == null) {
                this.entrySet = new ImmutableSetImpl.SetBackedSet<Map.Entry<K, V>>(new AbstractSet<Map.Entry<K, V>>(){

                    @Override
                    public int size() {
                        return this.size();
                    }

                    @Override
                    public boolean isEmpty() {
                        return this.isEmpty();
                    }

                    @Override
                    public boolean contains(Object o) {
                        return this.containsKey(o);
                    }

                    @Override
                    public Iterator<Map.Entry<K, V>> iterator() {
                        return new Iterator<Map.Entry<K, V>>(){
                            private int i = 0;

                            @Override
                            public boolean hasNext() {
                                return this.i < keys.length;
                            }

                            @Override
                            public Map.Entry<K, V> next() {
                                if (this.i < keys.length) {
                                    AbstractMap.SimpleEntry<Object, Object> result = new AbstractMap.SimpleEntry<Object, Object>(keys[this.i], values[this.i]);
                                    ++this.i;
                                    return result;
                                }
                                throw new NoSuchElementException();
                            }
                        };
                    }

                    @Override
                    public boolean add(Map.Entry<K, V> e) {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public boolean remove(Object o) {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public boolean addAll(Collection<? extends Map.Entry<K, V>> c) {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public boolean retainAll(Collection<?> c) {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public boolean removeAll(Collection<?> c) {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public void clear() {
                        throw new UnsupportedOperationException();
                    }
                });
            }
            return this.entrySet;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map)) {
                return false;
            }
            Map otherMap = (Map)o;
            if (otherMap.size() != this.size()) {
                return false;
            }
            for (int i = 0; i < this.keys.length; ++i) {
                if (Objects.equals(this.values[i], otherMap.get(this.keys[i]))) continue;
                return false;
            }
            return true;
        }

        @Override
        public ImmutableMap<K, V> with(K key, V value) {
            for (int i = 0; i < this.keys.length; ++i) {
                if (!Objects.equals(this.keys[i], key)) continue;
                if (Objects.equals(this.values[i], value)) {
                    return this;
                }
                Object[] values = (Object[])this.values.clone();
                values[i] = value;
                return new ArrayBackedMap<K, Object>(this.keys, values);
            }
            int l = this.keys.length;
            if (l < 5) {
                Object[] keys = new Object[l + 1];
                Object[] values = new Object[l + 1];
                System.arraycopy(this.keys, 0, keys, 0, l);
                System.arraycopy(this.values, 0, values, 0, l);
                keys[l] = key;
                values[l] = value;
                return new ArrayBackedMap<Object, Object>(keys, values);
            }
            return new ImmutableMap.Builder<K, V>(this).with(key, value).build();
        }

        @Override
        public ImmutableMap<K, V> matching(Predicate<K> predicate) {
            int[] matchingIndices = new int[this.keys.length];
            int matchingCount = 0;
            for (int i = 0; i < this.keys.length; ++i) {
                if (!predicate.test(this.keys[i])) continue;
                matchingIndices[matchingCount] = i;
                ++matchingCount;
            }
            if (matchingCount == 0) {
                return ImmutableMapImpl.empty();
            }
            if (matchingCount == 1) {
                return new SingleElementMap<K, V>(this.keys[matchingIndices[0]], this.values[matchingIndices[0]]);
            }
            if (matchingCount == this.keys.length) {
                return this;
            }
            Object[] keys = new Object[matchingCount];
            Object[] values = new Object[matchingCount];
            for (int i = 0; i < matchingCount; ++i) {
                keys[i] = this.keys[matchingIndices[i]];
                values[i] = this.values[matchingIndices[i]];
            }
            return new ArrayBackedMap<Object, Object>(keys, values);
        }

        @Override
        public boolean forAllKeysApplies(Predicate<K> predicate) {
            for (int i = 0; i < this.keys.length; ++i) {
                if (predicate.test(this.keys[i])) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean forAnyKeyApplies(Predicate<K> predicate) {
            for (int i = 0; i < this.keys.length; ++i) {
                if (!predicate.test(this.keys[i])) continue;
                return true;
            }
            return false;
        }

        @Override
        public <KT, VT> ImmutableMap<KT, VT> assertElementType(Class<KT> keyType, Class<VT> valueType) {
            ArrayBackedMap result = this;
            if (keyType.equals(Object.class) && valueType.equals(Object.class)) {
                return result;
            }
            for (int i = 0; i < this.keys.length; ++i) {
                K key = this.keys[i];
                if (!keyType.isAssignableFrom(key.getClass())) {
                    throw new ClassCastException("Key " + key + " is not compatible with expected type " + keyType);
                }
                V value = this.values[i];
                if (value == null || valueType.isAssignableFrom(value.getClass())) continue;
                throw new ClassCastException("Value " + value + " is not compatible with expected type " + valueType);
            }
            return result;
        }
    }

    static class HashArrayBackedMap<K, V>
    extends AbstractImmutableMap<K, V> {
        private static final int COLLISION_HEAD_ROOM = 4;
        private static final int NO_SPACE = Integer.MAX_VALUE;
        final int tableSize;
        final int size;
        private final K[] table1;
        private final V[] values1;
        private final K[] table2;
        private final V[] values2;
        private Map.Entry<K, V>[] flatEntries;
        private ImmutableSet<K> keySet;
        private ImmutableList<V> values;
        private ImmutableSet<Map.Entry<K, V>> entrySet;

        HashArrayBackedMap(int tableSize, int size, K[] table1, V[] values1, K[] table2, V[] values2) {
            this.tableSize = tableSize;
            this.size = size;
            this.table1 = table1;
            this.values1 = values1;
            this.table2 = table2;
            this.values2 = values2;
        }

        HashArrayBackedMap(int tableSize, int size, K[] table1, V[] values1, K[] table2, V[] values2, Map.Entry<K, V>[] flatEntries) {
            this.tableSize = tableSize;
            this.size = size;
            this.table1 = table1;
            this.values1 = values1;
            this.table2 = table2;
            this.values2 = values2;
            this.flatEntries = flatEntries;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public boolean isEmpty() {
            return this.size == 0;
        }

        @Override
        public boolean containsKey(Object key) {
            return this.containsKey(key, this.hashPosition(key));
        }

        boolean containsKey(Object key, int pos) {
            if (key.equals(this.table1[pos])) {
                return true;
            }
            return this.table2 != null && this.checkTable2(key, pos) < 0;
        }

        @Override
        public V get(Object key) {
            int pos = this.hashPosition(key);
            if (key.equals(this.table1[pos])) {
                return this.values1[pos];
            }
            if (this.table2 != null) {
                int check = this.checkTable2(key, pos);
                if (check < 0) {
                    int actualPos = -check - 1;
                    return this.values2[actualPos];
                }
                return null;
            }
            return null;
        }

        @Override
        public ImmutableSet<K> keySet() {
            ImmutableSet<K> result = this.keySet;
            if (result == null) {
                this.keySet = result = new ImmutableSetImpl.HashArrayBackedSet<K>(this.tableSize, this.size, this.table1, this.table2);
            }
            return result;
        }

        @Override
        public ImmutableList<V> values() {
            ImmutableList<V> result = this.values;
            if (result == null) {
                int i;
                V[] array = this.createVArray(this.size);
                int count = 0;
                for (i = 0; i < this.tableSize; ++i) {
                    if (this.table1[i] == null) continue;
                    array[count] = this.values1[i];
                    ++count;
                }
                if (this.table2 != null) {
                    for (i = 0; i < this.table2.length; ++i) {
                        if (this.table2[i] == null) continue;
                        array[count] = this.values2[i];
                        ++count;
                    }
                }
                this.values = result = new ImmutableListImpl.ArrayBackedList<V>(array);
            }
            return result;
        }

        @Override
        public ImmutableSet<Map.Entry<K, V>> entrySet() {
            ImmutableSet<Map.Entry<K, V>> result = this.entrySet;
            if (result == null) {
                this.entrySet = result = new ImmutableSetImpl.ArrayBackedSet<Map.Entry<K, V>>(this.getFlatEntries());
            }
            return result;
        }

        @Override
        public void forEach(BiConsumer<? super K, ? super V> action) {
            K key;
            int i;
            for (i = 0; i < this.table1.length; ++i) {
                key = this.table1[i];
                if (key == null) continue;
                action.accept(key, this.values1[i]);
            }
            if (this.table2 != null) {
                for (i = 0; i < this.table2.length; ++i) {
                    key = this.table2[i];
                    if (key == null) continue;
                    action.accept(key, this.values2[i]);
                }
            }
        }

        @Override
        public ImmutableMap<K, V> with(K otherKey, V otherValue) {
            int pos = this.hashPosition(otherKey);
            if (this.table1[pos] != null) {
                if (otherKey.equals(this.table1[pos])) {
                    if (Objects.equals(this.values1[pos], otherValue)) {
                        return this;
                    }
                    Object[] newValues1 = (Object[])this.values1.clone();
                    newValues1[pos] = otherValue;
                    return new HashArrayBackedMap<K, Object>(this.tableSize, this.size, this.table1, newValues1, this.table2, this.values2);
                }
                if (this.table2 != null) {
                    if (this.table2[pos] != null) {
                        int check = this.checkTable2(otherKey, pos);
                        if (check < 0) {
                            int actualPos = -check - 1;
                            if (Objects.equals(this.values2[actualPos], otherValue)) {
                                return this;
                            }
                            Object[] newValues2 = (Object[])this.values2.clone();
                            newValues2[actualPos] = otherValue;
                            return new HashArrayBackedMap<K, Object>(this.tableSize, this.size, this.table1, this.values1, this.table2, newValues2);
                        }
                        if (check == Integer.MAX_VALUE) {
                            return new WithMap<K, V>(this, otherKey, otherValue);
                        }
                        Object[] newTable2 = (Object[])this.table2.clone();
                        Object[] newValues2 = (Object[])this.values2.clone();
                        newTable2[check] = otherKey;
                        newValues2[check] = otherValue;
                        return new HashArrayBackedMap<Object, Object>(this.tableSize, this.size + 1, this.table1, this.values1, newTable2, newValues2);
                    }
                    Object[] newTable2 = (Object[])this.table2.clone();
                    Object[] newValues2 = (Object[])this.values2.clone();
                    newTable2[pos] = otherKey;
                    newValues2[pos] = otherValue;
                    return new HashArrayBackedMap<Object, Object>(this.tableSize, this.size + 1, this.table1, this.values1, newTable2, newValues2);
                }
                K[] newTable2 = this.createTable2();
                V[] newValues2 = this.createValues2();
                newTable2[pos] = otherKey;
                newValues2[pos] = otherValue;
                return new HashArrayBackedMap<K, V>(this.tableSize, this.size + 1, this.table1, this.values1, newTable2, newValues2);
            }
            Object[] newTable1 = (Object[])this.table1.clone();
            Object[] newValues1 = (Object[])this.values1.clone();
            newTable1[pos] = otherKey;
            newValues1[pos] = otherValue;
            return new HashArrayBackedMap<Object, Object>(this.tableSize, this.size + 1, newTable1, newValues1, this.table2, this.values2);
        }

        @Override
        public ImmutableMap<K, V> with(ImmutableMap<K, V> other) {
            int otherSize = other.size();
            if (otherSize == 0) {
                return this;
            }
            if (otherSize == 1) {
                Map.Entry otherOnly = (Map.Entry)other.entrySet().iterator().next();
                return this.with(otherOnly.getKey(), otherOnly.getValue());
            }
            return new Builder<K, V>(this).with(other).build();
        }

        @Override
        public ImmutableMap<K, V> matching(Predicate<K> predicate) {
            int table1count = 0;
            int table2count = 0;
            Object[] newTable1 = this.createTable1();
            V[] newValues1 = this.createValues1();
            Object[] newTable2 = this.table2 != null ? this.createTable2() : null;
            V[] newValues2 = this.values2 != null ? this.createValues2() : null;
            for (int i = 0; i < this.tableSize; ++i) {
                K k = this.table1[i];
                if (k == null || !predicate.test(k)) continue;
                newTable1[i] = k;
                newValues1[i] = this.values1[i];
                ++table1count;
            }
            int count = table1count;
            if (this.table2 != null) {
                for (int i = 0; i < this.table2.length; ++i) {
                    int pos;
                    K key = this.table2[i];
                    if (key == null || !predicate.test(key)) continue;
                    int n = pos = i == 0 ? 0 : this.hashPosition(key);
                    if (newTable1[pos] == null) {
                        newTable1[pos] = key;
                        newValues1[pos] = this.values2[i];
                        ++table1count;
                    } else {
                        int k = pos;
                        while (true) {
                            if (newTable2[k] == null) {
                                newTable2[k] = key;
                                newValues2[k] = this.values2[i];
                                ++table2count;
                                break;
                            }
                            ++k;
                        }
                    }
                    ++count;
                }
            }
            if (count == 0) {
                return ImmutableMapImpl.empty();
            }
            if (count == 1) {
                int pos1 = HashArrayBackedMap.findIndexOfNextNonNull(newTable1, 0);
                return new SingleElementMap<Object, V>(newTable1[pos1], newValues1[pos1]);
            }
            if (count == 2) {
                int pos1 = HashArrayBackedMap.findIndexOfNextNonNull(newTable1, 0);
                int pos2 = HashArrayBackedMap.findIndexOfNextNonNull(newTable1, pos1 + 1);
                if (pos2 != -1) {
                    return new TwoElementMap<Object, V>(newTable1[pos1], newValues1[pos1], newTable1[pos2], newValues1[pos2]);
                }
                pos2 = HashArrayBackedMap.findIndexOfNextNonNull(newTable2, 0);
                return new TwoElementMap<Object, V>(newTable1[pos1], newValues1[pos1], newTable2[pos2], newValues2[pos2]);
            }
            if (count < this.size) {
                if (table2count == 0) {
                    return new HashArrayBackedMap<Object, V>(this.tableSize, count, newTable1, newValues1, null, null);
                }
                return new HashArrayBackedMap<Object, V>(this.tableSize, count, newTable1, newValues1, newTable2, newValues2);
            }
            return this;
        }

        @Override
        public ImmutableMap<K, V> intersection(ImmutableSet<K> keys) {
            int otherSize = keys.size();
            if (otherSize == 0) {
                return ImmutableMapImpl.empty();
            }
            if (otherSize == 1) {
                K key = keys.only();
                if (this.containsKey(key)) {
                    return new SingleElementMap<K, V>(key, this.get(key));
                }
                return ImmutableMapImpl.empty();
            }
            if (keys instanceof ImmutableSetImpl.HashArrayBackedSet && ((ImmutableSetImpl.HashArrayBackedSet)keys).tableSize == this.tableSize) {
                return this.intersection((ImmutableSetImpl.HashArrayBackedSet)keys);
            }
            return this.matching(k -> keys.contains(k));
        }

        @Override
        private ImmutableMap<K, V> intersection(ImmutableSetImpl.HashArrayBackedSet<K> keys) {
            int count;
            K key;
            int i;
            int table1count = 0;
            int table2count = 0;
            Object[] newTable1 = this.createTable1();
            V[] newValues1 = this.createValues1();
            Object[] newTable2 = this.table2 != null ? this.createTable2() : null;
            V[] newValues2 = this.createValues2();
            for (i = 0; i < this.tableSize; ++i) {
                key = this.table1[i];
                if (key == null || !keys.contains(key, i)) continue;
                newTable1[i] = key;
                newValues1[i] = this.values1[i];
                ++table1count;
            }
            if (this.table2 != null) {
                block1: for (i = 0; i < this.table2.length; ++i) {
                    int pos;
                    key = this.table2[i];
                    if (key == null) continue;
                    int n = pos = i == 0 ? 0 : this.hashPosition(key);
                    if (!keys.contains(key, pos)) continue;
                    if (newTable1[pos] == null) {
                        newTable1[pos] = key;
                        newValues1[pos] = this.values2[i];
                        ++table1count;
                        continue;
                    }
                    int k = pos;
                    while (true) {
                        if (newTable2[k] == null) {
                            newTable2[k] = key;
                            newValues2[k] = this.values2[i];
                            ++table2count;
                            continue block1;
                        }
                        ++k;
                    }
                }
            }
            if ((count = table1count + table2count) == 0) {
                return ImmutableMapImpl.empty();
            }
            if (count == 1) {
                int pos1 = HashArrayBackedMap.findIndexOfNextNonNull(newTable1, 0);
                return new SingleElementMap<Object, V>(newTable1[pos1], newValues1[pos1]);
            }
            if (count == 2) {
                int pos1 = HashArrayBackedMap.findIndexOfNextNonNull(newTable1, 0);
                int pos2 = HashArrayBackedMap.findIndexOfNextNonNull(newTable1, pos1 + 1);
                if (pos2 != -1) {
                    return new TwoElementMap<Object, V>(newTable1[pos1], newValues1[pos1], newTable1[pos2], newValues1[pos2]);
                }
                pos2 = HashArrayBackedMap.findIndexOfNextNonNull(newTable2, 0);
                return new TwoElementMap<Object, V>(newTable1[pos1], newValues1[pos1], newTable2[pos2], newValues2[pos2]);
            }
            if (count < this.size) {
                if (table2count == 0) {
                    return new HashArrayBackedMap<Object, V>(this.tableSize, count, newTable1, newValues1, null, null);
                }
                return new HashArrayBackedMap<Object, V>(this.tableSize, count, newTable1, newValues1, newTable2, newValues2);
            }
            return this;
        }

        @Override
        public ImmutableMap<K, V> without(K other) {
            int pos = this.hashPosition(other);
            if (this.table1[pos] != null && other.equals(this.table1[pos])) {
                if (this.size == 1) {
                    return ImmutableMapImpl.empty();
                }
                Object[] newTable1 = (Object[])this.table1.clone();
                Object[] newValues1 = (Object[])this.values1.clone();
                newTable1[pos] = null;
                newValues1[pos] = null;
                if (this.table2 == null || this.table2[pos] == null) {
                    return new HashArrayBackedMap<Object, Object>(this.tableSize, this.size - 1, newTable1, newValues1, this.table2, this.values2);
                }
                for (int i = pos; i < this.table2.length && this.table2[i] != null; ++i) {
                    int otherPos = this.hashPosition(this.table2[i]);
                    if (otherPos != pos) continue;
                    newTable1[pos] = this.table2[i];
                    newValues1[pos] = this.values2[i];
                    Object[] newTable2 = (Object[])this.table2.clone();
                    Object[] newValues2 = (Object[])this.values2.clone();
                    newTable2[i] = null;
                    newValues2[i] = null;
                    HashArrayBackedMap.repositionCollisions(this.tableSize, newTable2, newValues2, i);
                    return new HashArrayBackedMap<Object, Object>(this.tableSize, this.size - 1, newTable1, newValues1, newTable2, newValues2);
                }
                return new HashArrayBackedMap<Object, Object>(this.tableSize, this.size - 1, newTable1, newValues1, this.table2, this.values2);
            }
            if (this.table2 != null && this.table2[pos] != null) {
                int check = this.checkTable2(other, pos);
                if (check < 0) {
                    if (this.size == 1) {
                        return ImmutableMapImpl.empty();
                    }
                    int actualPos = -check - 1;
                    Object[] newTable2 = (Object[])this.table2.clone();
                    Object[] newValues2 = (Object[])this.values2.clone();
                    newTable2[actualPos] = null;
                    newValues2[actualPos] = null;
                    HashArrayBackedMap.repositionCollisions(this.tableSize, newTable2, newValues2, actualPos);
                    return new HashArrayBackedMap<Object, Object>(this.tableSize, this.size - 1, this.table1, this.values1, newTable2, newValues2);
                }
                return this;
            }
            return this;
        }

        private static <K, V> void repositionCollisions(int tableSize, K[] table2, V[] values2, int start) {
            assert (table2[start] == null);
            int firstGapAt = -1;
            int lastGapAt = -1;
            block0: for (int i = start + 1; i < table2.length; ++i) {
                if (table2[i] == null) {
                    return;
                }
                int pos = HashArrayBackedMap.hashPosition(tableSize, table2[i]);
                if (firstGapAt == -1) {
                    if (pos != i) {
                        table2[i - 1] = table2[i];
                        values2[i - 1] = values2[i];
                        table2[i] = null;
                        values2[i] = null;
                        continue;
                    }
                    firstGapAt = i - 1;
                    lastGapAt = i - 1;
                    continue;
                }
                if (pos == i) {
                    if (table2[i - 1] != null) continue;
                    lastGapAt = i - 1;
                    continue;
                }
                if (pos == lastGapAt) {
                    assert (table2[lastGapAt] == null);
                    table2[lastGapAt] = table2[i];
                    values2[lastGapAt] = values2[i];
                    table2[i] = null;
                    values2[i] = null;
                    lastGapAt = -1;
                    continue;
                }
                for (int k = i - 1; k >= firstGapAt && k >= pos; --k) {
                    if (table2[k] != null) continue;
                    table2[k] = table2[i];
                    values2[k] = values2[i];
                    table2[i] = null;
                    values2[i] = null;
                    lastGapAt = -1;
                    continue block0;
                }
            }
        }

        private Map.Entry<K, V>[] getFlatEntries() {
            Map.Entry<K, V>[] result = this.flatEntries;
            if (result == null) {
                K key;
                int i;
                Map.Entry[] flatEntries = new Map.Entry[this.size];
                int k = 0;
                for (i = 0; i < this.table1.length; ++i) {
                    key = this.table1[i];
                    if (key == null) continue;
                    flatEntries[k] = new AbstractMap.SimpleEntry<K, V>(key, this.values1[i]);
                    ++k;
                }
                if (this.table2 != null) {
                    for (i = 0; i < this.table2.length; ++i) {
                        key = this.table2[i];
                        if (key == null) continue;
                        flatEntries[k] = new AbstractMap.SimpleEntry<K, V>(key, this.values2[i]);
                        ++k;
                    }
                }
                assert (this.size == k);
                result = flatEntries;
                this.flatEntries = flatEntries;
            }
            return result;
        }

        private K[] createTable1() {
            return new Object[this.tableSize];
        }

        private K[] createTable2() {
            return new Object[this.tableSize + 4];
        }

        private V[] createValues1() {
            return new Object[this.tableSize];
        }

        private V[] createValues2() {
            return new Object[this.tableSize + 4];
        }

        private static <E> E[] createTable1(int tableSize) {
            return new Object[tableSize];
        }

        private static <E> E[] createTable2(int tableSize) {
            return new Object[tableSize + 4];
        }

        private V[] createVArray(int size) {
            return new Object[size];
        }

        static int findIndexOfNextNonNull(Object[] array, int start) {
            for (int i = start; i < array.length; ++i) {
                if (array[i] == null) continue;
                return i;
            }
            return -1;
        }

        int hashPosition(Object e) {
            return HashArrayBackedMap.hashPosition(this.tableSize, e);
        }

        static int hashPosition(int tableSize, Object e) {
            if (e == null) {
                throw new IllegalArgumentException("ImmutableSet does not support null values");
            }
            int hash = e.hashCode();
            switch (tableSize) {
                case 16: {
                    return hash & 0xF ^ hash >> 4 & 0xF ^ hash >> 8 & 0xF ^ hash >> 12 & 0xF ^ hash >> 16 & 0xF ^ hash >> 20 & 0xF ^ hash >> 24 & 0xF ^ hash >> 28 & 0xF;
                }
                case 64: {
                    return hash & 0x3F ^ hash >> 6 & 0x3F ^ hash >> 12 & 0x3F ^ hash >> 18 & 0x3F ^ hash >> 24 & 0xF ^ hash >> 28 & 0xF;
                }
                case 256: {
                    return hash & 0xFF ^ hash >> 8 & 0xFF ^ hash >> 16 & 0xFF ^ hash >> 24 & 0xFF;
                }
            }
            throw new RuntimeException("Invalid tableSize " + tableSize);
        }

        int checkTable2(Object e, int hashPosition) {
            return HashArrayBackedMap.checkTable2(this.table2, e, hashPosition);
        }

        static <E> int checkTable2(E[] table2, Object e, int hashPosition) {
            if (table2[hashPosition] == null) {
                return hashPosition;
            }
            if (table2[hashPosition].equals(e)) {
                return -1 - hashPosition;
            }
            int max = hashPosition + 4;
            for (int i = hashPosition + 1; i <= max; ++i) {
                if (table2[i] == null) {
                    return i;
                }
                if (!table2[i].equals(e)) continue;
                return -1 - i;
            }
            return Integer.MAX_VALUE;
        }

        @Override
        public <VT> ImmutableMap<K, VT> mapValues(Function<V, VT> valueMappingFunction) {
            V v;
            int i;
            E[] newValues1 = HashArrayBackedMap.createTable1(this.tableSize);
            E[] newValues2 = this.values2 != null ? HashArrayBackedMap.createTable2(this.tableSize) : null;
            for (i = 0; i < this.tableSize; ++i) {
                v = this.values1[i];
                if (v == null) continue;
                newValues1[i] = valueMappingFunction.apply(v);
            }
            if (this.values2 != null) {
                for (i = 0; i < this.values2.length; ++i) {
                    v = this.values2[i];
                    if (v == null) continue;
                    newValues2[i] = valueMappingFunction.apply(v);
                }
            }
            return new HashArrayBackedMap(this.tableSize, this.size, this.table1, newValues1, this.table2, newValues2);
        }

        @Override
        public boolean forAllKeysApplies(Predicate<K> predicate) {
            K key;
            int i;
            for (i = 0; i < this.tableSize; ++i) {
                key = this.table1[i];
                if (key == null || predicate.test(key)) continue;
                return false;
            }
            if (this.table2 != null) {
                for (i = 0; i < this.table2.length; ++i) {
                    key = this.table2[i];
                    if (key == null || predicate.test(key)) continue;
                    return false;
                }
            }
            return true;
        }

        @Override
        public boolean forAnyKeyApplies(Predicate<K> predicate) {
            K key;
            int i;
            for (i = 0; i < this.tableSize; ++i) {
                key = this.table1[i];
                if (key == null || !predicate.test(key)) continue;
                return true;
            }
            if (this.table2 != null) {
                for (i = 0; i < this.table2.length; ++i) {
                    key = this.table2[i];
                    if (key == null || !predicate.test(key)) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public <KT, VT> ImmutableMap<KT, VT> assertElementType(Class<KT> keyType, Class<VT> valueType) {
            V value;
            K key;
            int i;
            HashArrayBackedMap result = this;
            if (keyType.equals(Object.class) && valueType.equals(Object.class)) {
                return result;
            }
            for (i = 0; i < this.tableSize; ++i) {
                key = this.table1[i];
                if (key == null) continue;
                if (!keyType.isAssignableFrom(key.getClass())) {
                    throw new ClassCastException("Key " + key + " is not compatible with expected type " + keyType);
                }
                value = this.values1[i];
                if (value == null || valueType.isAssignableFrom(value.getClass())) continue;
                throw new ClassCastException("Value " + value + " is not compatible with expected type " + valueType);
            }
            if (this.table2 != null) {
                for (i = 0; i < this.table2.length; ++i) {
                    key = this.table2[i];
                    if (key == null) continue;
                    if (!keyType.isAssignableFrom(key.getClass())) {
                        throw new ClassCastException("Key " + key + " is not compatible with expected type " + keyType);
                    }
                    value = this.values2[i];
                    if (value == null || valueType.isAssignableFrom(value.getClass())) continue;
                    throw new ClassCastException("Value " + value + " is not compatible with expected type " + valueType);
                }
            }
            return result;
        }

        static class Builder<K, V>
        extends InternalBuilder<K, V> {
            private static final Object T = new Object();
            private K[] table1;
            private V[] values1;
            private K[] table2;
            private V[] values2;
            private int size = 0;
            private final int tableSize;
            private boolean containsTombstones = false;
            private final K tombstone = T;

            public Builder(int tableSize) {
                this.tableSize = tableSize;
            }

            public Builder(HashArrayBackedMap<K, V> initialContent) {
                this.table1 = (Object[])((HashArrayBackedMap)initialContent).table1.clone();
                this.values1 = (Object[])((HashArrayBackedMap)initialContent).values1.clone();
                this.table2 = ((HashArrayBackedMap)initialContent).table2 != null ? (Object[])((HashArrayBackedMap)initialContent).table2.clone() : null;
                this.values2 = ((HashArrayBackedMap)initialContent).values2 != null ? (Object[])((HashArrayBackedMap)initialContent).values2.clone() : null;
                this.size = initialContent.size;
                this.tableSize = initialContent.tableSize;
            }

            @Override
            public InternalBuilder<K, V> with(K key, V value) {
                if (key == null) {
                    throw new IllegalArgumentException("Null keys are not supported");
                }
                return this.with(key, value, this.hashPosition(key));
            }

            private InternalBuilder<K, V> with(K key, V value, int pos) {
                if (this.table1 == null) {
                    this.table1 = HashArrayBackedMap.createTable1(this.tableSize);
                    this.values1 = HashArrayBackedMap.createTable1(this.tableSize);
                    this.table1[pos] = key;
                    this.values1[pos] = value;
                    ++this.size;
                    return this;
                }
                if (this.table1[pos] == null) {
                    this.table1[pos] = key;
                    this.values1[pos] = value;
                    ++this.size;
                    return this;
                }
                if (this.table1[pos].equals(key)) {
                    this.values1[pos] = value;
                    return this;
                }
                if (this.table2 == null) {
                    this.table2 = HashArrayBackedMap.createTable2(this.tableSize);
                    this.values2 = HashArrayBackedMap.createTable2(this.tableSize);
                    this.table2[pos] = key;
                    this.values2[pos] = value;
                    ++this.size;
                    return this;
                }
                if (this.table2[pos] == null) {
                    this.table2[pos] = key;
                    this.values2[pos] = value;
                    ++this.size;
                    return this;
                }
                int check = this.checkTable2(key, pos);
                if (check < 0) {
                    int actualPos = -check - 1;
                    this.values2[actualPos] = value;
                    return this;
                }
                if (check == Integer.MAX_VALUE) {
                    if (this.tableSize < 64) {
                        return new Builder<K, V>(64).with(this.build()).with(key, value);
                    }
                    if (this.tableSize < 256) {
                        return new Builder<K, V>(256).with(this.build()).with(key, value);
                    }
                    return new MapBackedMap.Builder<K, V>(this.build()).with((Object)key, (Object)value);
                }
                this.table2[check] = key;
                this.values2[check] = value;
                ++this.size;
                return this;
            }

            @Override
            InternalBuilder<K, V> with(Map<K, V> map) {
                InternalBuilder builder = this;
                for (Map.Entry<K, V> entry : map.entrySet()) {
                    builder = ((InternalBuilder)builder).with(entry.getKey(), entry.getValue());
                }
                return builder;
            }

            @Override
            public ImmutableMap<K, V> build() {
                if (this.size == 0) {
                    return ImmutableMap.empty();
                }
                if (this.size == 1) {
                    int i = HashArrayBackedMap.findIndexOfNextNonNull(this.table1, 0);
                    return new SingleElementMap<K, V>(this.table1[i], this.values1[i]);
                }
                if (this.size == 2) {
                    V value2;
                    K key2;
                    int i1 = HashArrayBackedMap.findIndexOfNextNonNull(this.table1, 0);
                    K key1 = this.table1[i1];
                    V value1 = this.values1[i1];
                    int i2 = HashArrayBackedMap.findIndexOfNextNonNull(this.table1, i1 + 1);
                    if (i2 != -1) {
                        key2 = this.table1[i2];
                        value2 = this.values1[i2];
                    } else {
                        i2 = this.findIndexOfNextNonNullNonTombstone(this.table2, 0);
                        key2 = this.table2[i2];
                        value2 = this.values2[i2];
                    }
                    return new TwoElementMap<K, V>(key1, value1, key2, value2);
                }
                this.clearTombstones();
                return new HashArrayBackedMap<K, V>(this.tableSize, this.size, this.table1, this.values1, this.table2, this.values2);
            }

            @Override
            <V2> ImmutableMap<K, V2> build(Function<V, V2> valueMappingFunction) {
                if (this.size == 0) {
                    return ImmutableMap.empty();
                }
                if (this.size == 1) {
                    int i = HashArrayBackedMap.findIndexOfNextNonNull(this.table1, 0);
                    return new SingleElementMap<K, V2>(this.table1[i], valueMappingFunction.apply(this.values1[i]));
                }
                if (this.size == 2) {
                    V value2;
                    K key2;
                    int i1 = HashArrayBackedMap.findIndexOfNextNonNull(this.table1, 0);
                    K key1 = this.table1[i1];
                    V value1 = this.values1[i1];
                    int i2 = HashArrayBackedMap.findIndexOfNextNonNull(this.table1, i1 + 1);
                    if (i2 != -1) {
                        key2 = this.table1[i2];
                        value2 = this.values1[i2];
                    } else {
                        i2 = this.findIndexOfNextNonNullNonTombstone(this.table2, 0);
                        key2 = this.table2[i2];
                        value2 = this.values2[i2];
                    }
                    return new TwoElementMap<K, V2>(key1, valueMappingFunction.apply(value1), key2, valueMappingFunction.apply(value2));
                }
                this.clearTombstones();
                return new HashArrayBackedMap<K, V2>(this.tableSize, this.size, this.table1, Builder.mapArray(this.values1, valueMappingFunction), this.table2, Builder.mapArray(this.values2, valueMappingFunction));
            }

            static <V, V2> V2[] mapArray(V[] array, Function<V, V2> valueMappingFunction) {
                if (array == null) {
                    return null;
                }
                V[] result = array;
                for (int i = 0; i < array.length; ++i) {
                    if (array[i] == null) continue;
                    result[i] = valueMappingFunction.apply(array[i]);
                }
                return result;
            }

            private void clearTombstones() {
                if (!this.containsTombstones) {
                    return;
                }
                int max = this.tableSize + 4 - 1;
                int table2count = 0;
                block0: for (int i = 0; i <= max; ++i) {
                    if (this.table2[i] == this.tombstone) {
                        int kMax;
                        this.table2[i] = null;
                        this.values2[i] = null;
                        for (int k = kMax = i >= this.tableSize ? max : i + 4; k > i; --k) {
                            if (this.table2[k] == null || this.table2[k] == this.tombstone || this.hashPosition(this.table2[k]) > i) continue;
                            this.table2[i] = this.table2[k];
                            this.values2[i] = this.values2[k];
                            this.table2[k] = this.tombstone;
                            this.values2[k] = null;
                            ++table2count;
                            continue block0;
                        }
                        continue;
                    }
                    if (this.table2[i] == null) continue;
                    ++table2count;
                }
                if (table2count == 0) {
                    this.table2 = null;
                }
            }

            @Override
            int size() {
                return this.size;
            }

            @Override
            boolean remove(K key) {
                int check;
                if (this.table1 == null) {
                    return false;
                }
                int position = this.hashPosition(key);
                if (this.table1[position] != null && this.table1[position].equals(key)) {
                    this.table1[position] = null;
                    this.values1[position] = null;
                    --this.size;
                    if (this.table2 != null && this.table2[position] != null) {
                        this.pullElementWithHashPositionFromTable2(position);
                    }
                    return true;
                }
                if (this.table2 != null && this.table2[position] != null && (check = this.checkTable2(key, position)) < 0) {
                    int actualPos = -check - 1;
                    this.table2[actualPos] = this.tombstone;
                    this.containsTombstones = true;
                    --this.size;
                    return true;
                }
                return false;
            }

            @Override
            boolean contains(K e) {
                if (this.table1 == null) {
                    return false;
                }
                int position = this.hashPosition(e);
                if (this.table1[position] != null && this.table1[position].equals(e)) {
                    return true;
                }
                if (this.table2 != null && this.table2[position] != null) {
                    int check = this.checkTable2(e, position);
                    return check < 0;
                }
                return false;
            }

            @Override
            V get(K k) {
                int check;
                if (this.table1 == null) {
                    return null;
                }
                int position = this.hashPosition(k);
                if (this.table1[position] != null && this.table1[position].equals(k)) {
                    return this.values1[position];
                }
                if (this.table2 != null && this.table2[position] != null && (check = this.checkTable2(k, position)) < 0) {
                    int actualPos = -check - 1;
                    return this.values2[actualPos];
                }
                return null;
            }

            @Override
            Set<K> keySet() {
                int i;
                if (this.size == 0) {
                    return ImmutableSet.empty();
                }
                ImmutableSet.Builder<K> result = new ImmutableSet.Builder<K>();
                if (this.table1 != null) {
                    for (i = 0; i < this.table1.length; ++i) {
                        if (this.table1[i] == null) continue;
                        result.add(this.table1[i]);
                    }
                }
                if (this.table2 != null) {
                    for (i = 0; i < this.table1.length; ++i) {
                        if (this.table2[i] == null || this.table2[i] == this.tombstone) continue;
                        result.add(this.table2[i]);
                    }
                }
                return result.build();
            }

            private int hashPosition(Object e) {
                return ImmutableSetImpl.HashArrayBackedSet.hashPosition(this.tableSize, e);
            }

            int checkTable2(Object e, int hashPosition) {
                int insertionPositionCandidate = Integer.MAX_VALUE;
                if (this.table2[hashPosition] == null) {
                    return hashPosition;
                }
                if (this.table2[hashPosition] == this.tombstone) {
                    insertionPositionCandidate = hashPosition;
                } else if (this.table2[hashPosition].equals(e)) {
                    return -1 - hashPosition;
                }
                int max = hashPosition + 4;
                for (int i = hashPosition + 1; i <= max; ++i) {
                    if (this.table2[i] == null) {
                        if (insertionPositionCandidate != Integer.MAX_VALUE) {
                            return insertionPositionCandidate;
                        }
                        return i;
                    }
                    if (this.table2[i] == this.tombstone) {
                        if (insertionPositionCandidate != Integer.MAX_VALUE) continue;
                        insertionPositionCandidate = i;
                        continue;
                    }
                    if (!this.table2[i].equals(e)) continue;
                    return -1 - i;
                }
                return insertionPositionCandidate;
            }

            void pullElementWithHashPositionFromTable2(int hashPosition) {
                int max = hashPosition + 4;
                for (int i = hashPosition; i <= max; ++i) {
                    if (this.table2[i] == null) {
                        this.table1[hashPosition] = null;
                        this.values1[hashPosition] = null;
                        return;
                    }
                    if (this.table2[i] == this.tombstone || this.hashPosition(this.table2[i]) != hashPosition) continue;
                    this.table1[hashPosition] = this.table2[i];
                    this.values1[hashPosition] = this.values2[i];
                    this.table2[i] = this.tombstone;
                    this.values2[i] = null;
                    this.containsTombstones = true;
                    return;
                }
                this.table1[hashPosition] = null;
                this.values1[hashPosition] = null;
            }

            int findIndexOfNextNonNullNonTombstone(Object[] array, int start) {
                for (int i = start; i < array.length; ++i) {
                    if (array[i] == null || array[i] == this.tombstone) continue;
                    return i;
                }
                return -1;
            }
        }
    }

    static class TwoElementMap<K, V>
    extends AbstractImmutableMap<K, V> {
        private final K key1;
        private final V value1;
        private final K key2;
        private final V value2;
        private ImmutableSet<K> keySet;
        private ImmutableList<V> values;
        private ImmutableSet<Map.Entry<K, V>> entrySet;

        TwoElementMap(K key1, V value1, K key2, V value2) {
            this.key1 = key1;
            this.value1 = value1;
            this.key2 = key2;
            this.value2 = value2;
        }

        @Override
        public int size() {
            return 2;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean containsValue(Object value) {
            return Objects.equals(this.value1, value) || Objects.equals(this.value2, value);
        }

        @Override
        public boolean containsKey(Object key) {
            return Objects.equals(this.key1, key) || Objects.equals(this.key2, key);
        }

        @Override
        public V get(Object key) {
            if (Objects.equals(this.key1, key)) {
                return this.value1;
            }
            if (Objects.equals(this.key2, key)) {
                return this.value2;
            }
            return null;
        }

        @Override
        public ImmutableSet<K> keySet() {
            if (this.keySet == null) {
                this.keySet = ImmutableSet.of(this.key1, this.key2);
            }
            return this.keySet;
        }

        @Override
        public ImmutableList<V> values() {
            if (this.values == null) {
                this.values = ImmutableList.of(this.value1, this.value2);
            }
            return this.values;
        }

        @Override
        public ImmutableSet<Map.Entry<K, V>> entrySet() {
            if (this.entrySet == null) {
                this.entrySet = ImmutableSet.of(new AbstractMap.SimpleEntry<K, V>(this.key1, this.value1), new AbstractMap.SimpleEntry<K, V>(this.key2, this.value2));
            }
            return this.entrySet;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map)) {
                return false;
            }
            Map otherMap = (Map)o;
            if (otherMap.size() != 2) {
                return false;
            }
            return Objects.equals(this.value1, otherMap.get(this.key1)) && Objects.equals(this.value2, otherMap.get(this.key2));
        }

        @Override
        public ImmutableMap<K, V> with(K key, V value) {
            if (Objects.equals(this.key1, key)) {
                if (Objects.equals(this.value1, value)) {
                    return this;
                }
                return new TwoElementMap<K, V>(this.key1, value, this.key2, this.value2);
            }
            if (Objects.equals(this.key2, key)) {
                if (Objects.equals(this.value2, value)) {
                    return this;
                }
                return new TwoElementMap<K, V>(this.key1, this.value1, this.key2, value);
            }
            return new ArrayBackedMap<K, V>(this.key1, this.value1, this.key2, this.value2, key, value);
        }

        @Override
        public ImmutableMap<K, V> intersection(ImmutableSet<K> keys) {
            if (keys.contains(this.key1)) {
                if (keys.contains(this.key2)) {
                    return this;
                }
                return new SingleElementMap<K, V>(this.key1, this.value1);
            }
            if (keys.contains(this.key2)) {
                return new SingleElementMap<K, V>(this.key2, this.value2);
            }
            return ImmutableMapImpl.empty();
        }

        @Override
        public ImmutableMap<K, V> matching(Predicate<K> predicate) {
            if (predicate.test(this.key1)) {
                if (predicate.test(this.key2)) {
                    return this;
                }
                return new SingleElementMap<K, V>(this.key1, this.value1);
            }
            if (predicate.test(this.key2)) {
                return new SingleElementMap<K, V>(this.key2, this.value2);
            }
            return ImmutableMapImpl.empty();
        }

        @Override
        public void forEach(BiConsumer<? super K, ? super V> action) {
            action.accept(this.key1, this.value1);
            action.accept(this.key2, this.value2);
        }

        @Override
        public boolean containsAny(ImmutableSet<K> keys) {
            return keys.contains(this.key1) || keys.contains(this.key2);
        }

        @Override
        public ImmutableList<V> values(BiPredicate<K, V> predicate) {
            if (predicate.test(this.key1, this.value1)) {
                if (predicate.test(this.key2, this.value2)) {
                    return this.values();
                }
                return ImmutableList.of(this.value1);
            }
            if (predicate.test(this.key2, this.value2)) {
                return ImmutableList.of(this.value2);
            }
            return ImmutableList.empty();
        }

        @Override
        public ImmutableList<V> valuesForKeys(ImmutableSet<K> keys) {
            if (keys.contains(this.key1)) {
                if (keys.contains(this.key2)) {
                    return this.values();
                }
                return ImmutableList.of(this.value1);
            }
            if (keys.contains(this.key2)) {
                return ImmutableList.of(this.value2);
            }
            return ImmutableList.empty();
        }

        @Override
        public <VT> ImmutableMap<K, VT> mapValues(Function<V, VT> valueMappingFunction) {
            return new TwoElementMap<K, VT>(this.key1, valueMappingFunction.apply(this.value1), this.key2, valueMappingFunction.apply(this.value2));
        }

        @Override
        public boolean forAllKeysApplies(Predicate<K> predicate) {
            return predicate.test(this.key1) && predicate.test(this.key2);
        }

        @Override
        public boolean forAnyKeyApplies(Predicate<K> predicate) {
            return predicate.test(this.key1) || predicate.test(this.key2);
        }

        @Override
        public <KT, VT> ImmutableMap<KT, VT> assertElementType(Class<KT> keyType, Class<VT> valueType) {
            if (!keyType.isAssignableFrom(this.key1.getClass())) {
                throw new ClassCastException("Key " + this.key1 + " is not compatible with expected type " + keyType);
            }
            if (!keyType.isAssignableFrom(this.key2.getClass())) {
                throw new ClassCastException("Key " + this.key2 + " is not compatible with expected type " + keyType);
            }
            if (this.value1 != null && !valueType.isAssignableFrom(this.value1.getClass())) {
                throw new ClassCastException("Value " + this.value1 + " is not compatible with expected type " + valueType);
            }
            if (this.value2 != null && !valueType.isAssignableFrom(this.value2.getClass())) {
                throw new ClassCastException("Value " + this.value2 + " is not compatible with expected type " + valueType);
            }
            TwoElementMap result = this;
            return result;
        }

        @Override
        public <KT> ImmutableMap<KT, V> ensureKeyType(Class<KT> keyType, Function<Object, KT> conversionFunction) {
            if (keyType.isAssignableFrom(this.key1.getClass()) && keyType.isAssignableFrom(this.key2.getClass())) {
                TwoElementMap result = this;
                return result;
            }
            return new TwoElementMap<KT, V>(conversionFunction.apply(this.key1), this.value1, conversionFunction.apply(this.key2), this.value2);
        }
    }

    static class SingleElementMap<K, V>
    extends AbstractImmutableMap<K, V> {
        private final K key;
        private final V value;
        private ImmutableSet<K> keySet;
        private ImmutableList<V> values;
        private ImmutableSet<Map.Entry<K, V>> entrySet;

        SingleElementMap(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean containsValue(Object value) {
            return Objects.equals(this.value, value);
        }

        @Override
        public boolean containsKey(Object key) {
            return Objects.equals(this.key, key);
        }

        @Override
        public V get(Object key) {
            if (Objects.equals(this.key, key)) {
                return this.value;
            }
            return null;
        }

        @Override
        public ImmutableSet<K> keySet() {
            if (this.keySet == null) {
                this.keySet = ImmutableSet.of(this.key);
            }
            return this.keySet;
        }

        @Override
        public ImmutableList<V> values() {
            if (this.values == null) {
                this.values = ImmutableList.of(this.value);
            }
            return this.values;
        }

        @Override
        public ImmutableSet<Map.Entry<K, V>> entrySet() {
            if (this.entrySet == null) {
                this.entrySet = ImmutableSet.of(new AbstractMap.SimpleEntry<K, V>(this.key, this.value));
            }
            return this.entrySet;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map)) {
                return false;
            }
            Map otherMap = (Map)o;
            if (otherMap.size() != 1) {
                return false;
            }
            Map.Entry entry = otherMap.entrySet().iterator().next();
            return Objects.equals(this.key, entry.getKey()) && Objects.equals(this.value, entry.getValue());
        }

        @Override
        public ImmutableMap<K, V> with(K key, V value) {
            if (this.key.equals(key)) {
                if (Objects.equals(this.value, value)) {
                    return this;
                }
                return new SingleElementMap<K, V>(key, value);
            }
            return new TwoElementMap<K, V>(this.key, this.value, key, value);
        }

        @Override
        public ImmutableMap<K, V> intersection(ImmutableSet<K> keys) {
            if (keys.contains(this.key)) {
                return this;
            }
            return ImmutableMapImpl.empty();
        }

        @Override
        public ImmutableMap<K, V> matching(Predicate<K> predicate) {
            if (predicate.test(this.key)) {
                return this;
            }
            return ImmutableMapImpl.empty();
        }

        @Override
        public void forEach(BiConsumer<? super K, ? super V> action) {
            action.accept(this.key, this.value);
        }

        @Override
        public boolean containsAny(ImmutableSet<K> keys) {
            return keys.contains(this.key);
        }

        @Override
        public ImmutableList<V> values(BiPredicate<K, V> predicate) {
            if (predicate.test(this.key, this.value)) {
                return this.values();
            }
            return ImmutableList.empty();
        }

        @Override
        public ImmutableList<V> valuesForKeys(ImmutableSet<K> keys) {
            if (keys.contains(this.key)) {
                return this.values();
            }
            return ImmutableList.empty();
        }

        @Override
        public <KT, VT> ImmutableMap<KT, VT> map(Function<K, KT> keyMappingFunction, Function<V, VT> valueMappingFunction) {
            return new SingleElementMap<KT, VT>(keyMappingFunction.apply(this.key), valueMappingFunction.apply(this.value));
        }

        @Override
        public <VT> ImmutableMap<K, VT> mapValues(Function<V, VT> valueMappingFunction) {
            return new SingleElementMap<K, VT>(this.key, valueMappingFunction.apply(this.value));
        }

        @Override
        public boolean forAllKeysApplies(Predicate<K> predicate) {
            return predicate.test(this.key);
        }

        @Override
        public boolean forAnyKeyApplies(Predicate<K> predicate) {
            return predicate.test(this.key);
        }

        @Override
        public <KT, VT> ImmutableMap<KT, VT> assertElementType(Class<KT> keyType, Class<VT> valueType) {
            if (this.key != null && !keyType.isAssignableFrom(this.key.getClass())) {
                throw new ClassCastException("Key " + this.key + " is not compatible with expected type " + keyType);
            }
            if (this.value != null && !valueType.isAssignableFrom(this.value.getClass())) {
                throw new ClassCastException("Value " + this.value + " is not compatible with expected type " + valueType);
            }
            SingleElementMap result = this;
            return result;
        }

        @Override
        public <KT> ImmutableMap<KT, V> ensureKeyType(Class<KT> keyType, Function<Object, KT> conversionFunction) {
            if (keyType.isAssignableFrom(this.key.getClass())) {
                SingleElementMap result = this;
                return result;
            }
            return new SingleElementMap<KT, V>(conversionFunction.apply(this.key), this.value);
        }
    }

    static abstract class InternalBuilder<K, V> {
        InternalBuilder() {
        }

        abstract InternalBuilder<K, V> with(K var1, V var2);

        abstract InternalBuilder<K, V> with(Map<K, V> var1);

        abstract boolean remove(K var1);

        abstract boolean contains(K var1);

        abstract V get(K var1);

        abstract ImmutableMap<K, V> build();

        abstract <V2> ImmutableMap<K, V2> build(Function<V, V2> var1);

        abstract int size();

        abstract Set<K> keySet();
    }
}

